package fr.asip.cps3.exemple.vues.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser la bote de dialogue de saisie d'un attribut d'objet
 */
public class SaisieAttributObjet  {

	JFrame fenetre;
	protected String titre;
	protected JDialog d;
	protected JLabel libelleAttribut;
	protected JTextArea attribut;
	protected JScrollPane scrollAttribut;
	protected JPanel panel;
	protected JButton btnValider;
	protected JButton btnAnnuler;
	protected int choixUtilisateur;
	protected byte[] valeurAttribut;
	
	/**
	 * Constructeur
	 * @param fenetre fentre parente de la dialog
	 */
	public SaisieAttributObjet(JFrame fenetre, String titre, String libelleObjet) {
		
		this.fenetre = fenetre;
		this.titre = titre;
		d = new JDialog(fenetre);
		libelleAttribut = new JLabel("Modifier la valeur du jeton "+libelleObjet+" (sous forme hxadcimale) : ");
		attribut = new JTextArea(" ");
		
		attribut.setLineWrap(true);
		attribut.setWrapStyleWord(true);
		scrollAttribut = new JScrollPane(attribut,ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollAttribut.setBackground(Color.white);		
		scrollAttribut.setPreferredSize(new Dimension(400, 400));
		
		btnValider = new JButton("Valider");
		btnAnnuler = new JButton("Annuler");
		
	}

	/**
	 * Affiche la dialog
	 */
	public void affiche() {
		
		panel = new JPanel();
		
		// Cration du layout
		panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        
        // Ajout des composants
        GridBagHelper g = new GridBagHelper(panel);
        // Ligne 0
        g.ajoute(libelleAttribut, EcranUtil.styleLibelleDialogLigneEntiere, 0, 0, 1, 2);
        g.ajoute(scrollAttribut, EcranUtil.styleScrollSaisieObjet, 1, 0, 1, 2);
        g.ajoute(btnValider, EcranUtil.styleBoutonDialogValider, 3, 0, 1, 1);
        g.ajoute(btnAnnuler, EcranUtil.styleBoutonDialogAnnuler, 3, 1, 1, 1);
		d.getContentPane().add(panel,BorderLayout.CENTER);
		d.setTitle(titre);
		d.setModal(true);
		d.pack();
		
		// centrage de la dialog
        Rectangle r = fenetre.getBounds();
        int x = r.x + (r.width - d.getSize().width)/2;
        int y = r.y + (r.height - d.getSize().height)/2;
        d.setLocation(x, y);
		
		ActionListener ecouteur = new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if(ae.getSource() == btnAnnuler) {
					choixUtilisateur = -1;
				} else {
					valeurAttribut = (attribut.getText() != null)?TraitementsUtil.getOctetsSansFormatage(attribut.getText()):null;
					choixUtilisateur = 1;
				}
				d.dispose();
			}
		};

		btnValider.addActionListener(ecouteur);
		btnAnnuler.addActionListener(ecouteur);
		
		d.setVisible(true);		
				
		
	}
	
	/**
     * Renvoie les donnes de l'objet
     * @return Donnes de l'objet
     */
	public byte[] getValeurAttribut() {
		return valeurAttribut;
	}

	/**
     * Affecte les donnes de l'objet
     * @return Donnes de l'objet
     */
	public void setAttribut(String attribut) {
		this.attribut.setText(attribut);
	}	
	
	/**
	 * Accesseur
	 * @return Choix utilisateur
	 */
	public int getChoixUtilisateur(){
		return choixUtilisateur;
	}	
	
}